﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace UlamekDemo
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            //konstruktory i obiekty stałe
            Ulamek u2 = new Ulamek(2, 1);
            Ulamek u0 = Ulamek.Zero;
            Ulamek uP = Ulamek.Polowa;
            MessageBox.Show(uP.ToString());

            //metoda statyczna
            MessageBox.Show(Ulamek.Info());

            //metoda Uprosc
            Ulamek u = new Ulamek(4, -2);
            u.Uprosc();
            MessageBox.Show(u.ToString());

            //własności
            Ulamek u1 = new Ulamek { Licznik = 1, Mianownik = 2 };
            MessageBox.Show(u1.ToString());

            //operatory arytmetyczne
            Ulamek a = Ulamek.Polowa;
            Ulamek b = Ulamek.Cwierc;

            MessageBox.Show((a + b).ToString());
            MessageBox.Show((a - b).ToString());
            MessageBox.Show((a * b).ToString());
            MessageBox.Show((a / b).ToString());

            //operatory porównania
            MessageBox.Show("a jest " + (a < b ? "mniejsze" : "większe") + " od b");

            //operatory konwersji
            double r = (double)Ulamek.Polowa;
            MessageBox.Show(r.ToString());
            Ulamek c = 1;
            MessageBox.Show(c.ToString());
        }

        private void button2_Click(object sender, EventArgs e)
        {
            Ulamek[] tablica = new Ulamek[10];
            for (int i = 0; i < tablica.Length; i++) tablica[i] = new Ulamek(1, i + 1);

            string s = "Przed sortowaniem:\n";
            foreach (Ulamek u in tablica) s += u.ToString() + "=" + u.ToDouble().ToString() + "\n";
            MessageBox.Show(s);

            try
            {
                Array.Sort(tablica);
            }
            catch (Exception exc)
            {
                MessageBox.Show(exc.Message);
            }

            s = "Po sortowaniu:\n";
            foreach (Ulamek u in tablica) s += u.ToString() + "=" + u.ToDouble().ToString() + "\n";
            MessageBox.Show(s);
        }
    }
}
